'use client'

import Link from 'next/link'
import { useState } from 'react'

export default function Navigation() {
  const [isOpen, setIsOpen] = useState(false)

  return (
    <nav className="bg-gray-900 shadow-lg sticky top-0 z-50">
      <div className="container">
        <div className="flex justify-between items-center h-20">
          {/* Logo */}
          <Link href="/" className="flex items-center">
            <span className="text-2xl font-bold text-white">
              NINE THREE <span className="text-red-600">MERCH</span>
            </span>
          </Link>

          {/* Desktop Menu */}
          <div className="hidden md:flex space-x-8">
            <Link href="/" className="text-white hover:text-yellow-400 transition-colors">
              Home
            </Link>
            <Link href="/services" className="text-white hover:text-yellow-400 transition-colors">
              Services
            </Link>
            <Link href="/shop" className="text-white hover:text-yellow-400 transition-colors">
              Shop
            </Link>
            <Link href="/gallery" className="text-white hover:text-yellow-400 transition-colors">
              Gallery
            </Link>
            <Link href="/about" className="text-white hover:text-yellow-400 transition-colors">
              About
            </Link>
            <Link href="/contact" className="text-white hover:text-yellow-400 transition-colors">
              Contact
            </Link>
          </div>

          {/* Mobile Menu Button */}
          <button
            onClick={() => setIsOpen(!isOpen)}
            className="md:hidden text-white"
          >
            <svg className="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              {isOpen ? (
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M6 18L18 6M6 6l12 12" />
              ) : (
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
              )}
            </svg>
          </button>
        </div>

        {/* Mobile Menu */}
        {isOpen && (
          <div className="md:hidden">
            <div className="px-2 pt-2 pb-3 space-y-1">
              <Link href="/" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                Home
              </Link>
              <Link href="/services" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                Services
              </Link>
              <Link href="/shop" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                Shop
              </Link>
              <Link href="/gallery" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                Gallery
              </Link>
              <Link href="/about" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                About
              </Link>
              <Link href="/contact" className="block px-3 py-2 text-white hover:bg-red-600 rounded">
                Contact
              </Link>
            </div>
          </div>
        )}
      </div>
    </nav>
  )
}
